% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilson.R
\name{dof}
\alias{dof}
\title{Calculate degrees of freedom used in calculating
confidence intervals of t-distributed proportion point
estimate \eqn{\bar{Q}_m}}
\usage{
dof(qhats, m, nrow)
}
\arguments{
\item{qhats}{vector of Qhats(means of response for each imputed dataset)}

\item{m}{number of imputed datasets}

\item{nrow}{number of observations in the imputed dataset}
}
\value{
degrees of freedom
}
\description{
Calculate degrees of freedom used in calculating
confidence intervals of t-distributed proportion point
estimate \eqn{\bar{Q}_m}
}
\examples{
imp = mice::mice(mice::nhanes)
qhats = Qhats(imp, "hyp")
m = imp$m
nrow = imp$data \%>\% nrow()
dof(qhats, m, nrow)

}
