% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEce.R
\name{plot.MLEce}
\alias{plot.MLEce}
\title{Providing some plots for MLEce}
\usage{
\method{plot}{MLEce}(
  x,
  which = c(1, 2, 3, 4),
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  ...
)
}
\arguments{
\item{x}{an object of class "MLEce" made by the function \code{MLEce}.}

\item{which}{if a subset of the plots is required, specify a subset of 1:4}

\item{ask}{logical; if TRUE, the user is asked before each plot.}

\item{...}{not used, but exists because of the compatibility.}
}
\value{
returns plots for MLEce which describe "details".
}
\description{
\code{plot} method for a class "MLEce".
}
\details{
The first figure is a boxplot for given data.
The second figure is a contour line drawn by the probability density function of the estimated parameter based on MLEce.
the x-axis is the first column of data and the y-axis is the second column of data.
The third figure is a marginally fitted probability density plot for the first column of input data.
It provides a fitted line for each of CME, MLE and MLEce.
The fourth figure is a marginally fitted probability density plot for the second column of input data.
It can also provide a fitted line for each of CME, MLE and MLEce.
}
\examples{
datt = rBiGam(100, c(1,4,5))
res = MLEce(datt, "BiGam", boots = 50)
plot(res, c(1))
}
