% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{summary.MLGL}
\alias{summary.MLGL}
\title{Object Summaries

Summary of a \code{\link{MLGL}} object}
\usage{
\method{summary}{MLGL}(object, ...)
}
\arguments{
\item{object}{\code{\link{MLGL}} object}

\item{...}{Not used.}
}
\description{
Object Summaries

Summary of a \code{\link{MLGL}} object
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
# Apply MLGL method
res <- MLGL(X, y)
summary(res)
}
\seealso{
\link{MLGL} \link{print.MLGL}
}
