% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moicorrector.R
\name{corrector_string}
\alias{corrector_string}
\title{Removes punctuation characters and typos from data
entries}
\usage{
corrector_string(y, c_l, r_w, conm, cons, cha_string, rw_col, coding, multsh)
}
\arguments{
\item{y}{string; entry of a cell.}

\item{c_l}{string; marker label.}

\item{r_w}{numeric; sample ID's row number in the excel
file.}

\item{conm}{numeric; the multiple column per marker
identifier. For the data of format multiple columns
conm > 1.}

\item{cons}{numeric; the multiple row per sample
identifier. For the data of format multiple rows cons >
1.}

\item{cha_string}{string vector; the vector of
punctuation characters plus numerics form 1 to 9. See
\code{\link{moi_prerequisite}}.}

\item{rw_col}{string vector; variable used to switch
between row and column in case of transposed data.
Namely, \code{c("rows ", "row ", "column ", "columns
")}.}

\item{multsh}{string; reports warnings for multiple
worksheet datasets.}
}
\value{
a list of following elements: 1) a vector of
  lineages found on a marker (SNP, amino-acid or codon)
  in a single cell. Each element corresponds to one and
  only one lineage and it is free from typos, 2) an
  identifier whose value is 1 if a warning takes place.
}
\description{
This function is designed to find the
  lineages present on a SNP, amino-acid and codon marker
  in a single cell.
}
\seealso{
For further details see: \code{\link{moimport}},
  \code{\link{moi_marker}}.
}
\keyword{internal}
