% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moidecoder.R
\name{decoder_codon}
\alias{decoder_codon}
\title{Translates the standard ambiguity codes for nucleotides
(codon decoder)}
\usage{
decoder_codon(
  y,
  c_l,
  r_w,
  aa_1,
  aa_2,
  compact,
  codon_s,
  coding,
  rw_col,
  multsh
)
}
\arguments{
\item{y}{numeric vector; entries in a cell corresponding
to a specific sample and a specific marker.}

\item{c_l}{string; marker label.}

\item{r_w}{numeric; sample ID's row number in the excel
file.}

\item{aa_1}{string vector; vector of different amino
acids.}

\item{aa_2}{string vector; vector of different codons.}

\item{compact}{string vector; vector of different codons
in compact form.}

\item{codon_s}{string vector; vector of different codons.}

\item{coding}{string; coding class of the molecular
marker.}

\item{rw_col}{string vector; variable used to switch
between row and column in case of transposed data.
Namely, \code{c("rows ", "row ", "column ", "columns
")}.}

\item{multsh}{string; reports warnings for multiple
worksheet datasets.}
}
\value{
a list of two elements: 1) a vector of codons in
  triplet designation on a marker corresponding to a
  sample in pre-specified coding class. 2) an identifier
  whose value is 1 if a warning takes place.
}
\description{
Translates the standard ambiguity codes for
  nucleotides in codon form from a pre-specified coding
  class to triplet designation of codons.
}
\seealso{
For further details see: \code{\link{moimport}},
  \code{\link{moi_marker}} and
  \code{\link{corrector_string}}.
}
\keyword{internal}
