% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moimarker.R
\name{moi_marker}
\alias{moi_marker}
\title{Extracts lineages of samples at a specific marker}
\usage{
moi_marker(
  col_j,
  c_l,
  sam,
  samorder,
  conm,
  cons,
  molecular,
  coding,
  cha_num,
  cha_string,
  ambeguity_code,
  represented_bases,
  aa_1,
  aa_2,
  let_3,
  amino_acid,
  aa_symbol,
  compact,
  codon_s,
  rw_col,
  multsh
)
}
\arguments{
\item{col_j}{vector; column vector of a specific marker.}

\item{c_l}{string; marker label.}

\item{sam}{numeric vector; vector which its elements
specify where a new sample starts.}

\item{samorder}{a vector which its elements specify where
a new sample starts.}

\item{conm}{numeric; the multiple column identifier. For
the data of format multiple columns conm > 1.}

\item{cons}{numeric; the multiple row identifier. For the
data of format multiple rows conm > 1.}

\item{molecular}{string; type of molecular data.}

\item{coding}{string; coding class of the molecular
marker.}

\item{cha_num}{string vector; vector of symbols (used for
microsatellite data).}

\item{cha_string}{string vector; vector of symbols (used
for snp and amino acid).}

\item{ambeguity_code}{string vector; ambeguity codes for
snp data.}

\item{represented_bases}{string vector; represented bases
for those ambeguity codes.}

\item{aa_1}{string vector; vector of different amino
acids.}

\item{aa_2}{string vector; vector of different codons.}

\item{let_3}{string vector; vector of amino acids in
3-letter designation.}

\item{amino_acid}{string vector; vector of amino acids in
full name.}

\item{aa_symbol}{string vector; vector of amino acids in
one letter designation.}

\item{compact}{string vector; vector of different codons
in compact form.}

\item{codon_s}{string vector; vector of different codons.}

\item{rw_col}{string vector; variable used to switch
between row and column in case of transposed data.
Namely, \code{c("rows ", "row ", "column ", "columns
")}.}

\item{multsh}{string; reports warnings for multiple
worksheet datasets.}
}
\value{
a list with the following elements: 1) a list
  with elements containing lineages for a specific sample
  on a specific marker. The order in which samples are
  entered in dataset is preserved in the list. The
  lineages are free from typos and are transformed to
  pre-specified coding class, 2) an identifier whose
  value is 1 if a warning takes place.
}
\description{
For a specific marker, the function goes
  from one sample to another and finds lineages with the
  help of the following functions:
  \code{\link{corrector_numeric}} along with
  \code{\link{decoder_str}},
  \code{\link{corrector_string}} along with
  \code{\link{decoder_aminoacid}} and
  \code{\link{corrector_string}} along with
  \code{\link{decoder_snp}}. Each of these functions are
  suitable for a particular type of molecular data.
}
\seealso{
For further details, please see the following
  functions: \code{moimport}
}
\keyword{internal}
