% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDifferentialAccessibleTiles.R
\name{getDifferentialAccessibleTiles}
\alias{getDifferentialAccessibleTiles}
\title{\code{getDifferentialAccessibleTiles}}
\usage{
getDifferentialAccessibleTiles(
  SampleTileObj,
  cellPopulation,
  groupColumn,
  foreground,
  background,
  signalThreshold = 12,
  minZeroDiff = 0.5,
  fdrToDisplay = 0.2,
  outputGRanges = TRUE,
  numCores = 2,
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObj}{The SummarizedExperiment object output from
getSampleTileMatrix}

\item{cellPopulation}{A string denoting the cell population of interest}

\item{groupColumn}{The column containing sample group labels}

\item{foreground}{The foreground group of samples for differential comparison}

\item{background}{The background group of samples for differential comparison}

\item{signalThreshold}{Minimum median intensity required to keep tiles for
differential testing to increase statistical power in small sample cohorts.
Default is 12.}

\item{minZeroDiff}{Minimum difference in average dropout rates across groups
require to keep tiles for differential testing. Default is 0.5 (50\%).}

\item{fdrToDisplay}{False-discovery rate used only for standard
output messaging. Default is 0.2.}

\item{outputGRanges}{Outputs a GRanges if TRUE and a data.frame if
FALSE. Default is TRUE.}

\item{numCores}{The number of cores to use with multiprocessing.
Default is 1.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
full_results The differential accessibility results as a GRanges or
  matrix data.frame depending on the flag `outputGRanges`.
}
\description{
\code{getDifferentialAccessibleTiles} allows you to
  determine whether regions of chromatin are differentially accessible
  between groups by conducting a test
}
\examples{
\dontrun{
cellPopulation <- "MAIT"
foreground <- "Positive"
background <- "Negative" 
# Standard output will display the number of tiles found below a false-discovery rate threshold.
# This parameter does not filter results and only affects the aforementioned message. 
fdrToDisplay <- 0.2
# Choose to output a GRanges or data.frame.
# Default is TRUE
outputGRanges <- TRUE
# SampleTileMatrices is the output of MOCHA::getSampleTileMatrix
differentials <- MOCHA::getDifferentialAccessibleTiles(
  SampleTileObj = SampleTileMatrices, 
  cellPopulation = cellPopulation, 
  groupColumn = groupColumn, 
  foreground = foreground, 
  background = background, 
  fdrToDisplay = fdrToDisplay, 
  outputGRanges = outputGRanges, 
  numCores = numCores
)
}
}
