% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLMEM.R
\name{pilotLMEM}
\alias{pilotLMEM}
\title{Execute a pilot run of single linear model on a subset of data}
\usage{
pilotLMEM(
  ExperimentObj,
  cellPopulation = NULL,
  modelFormula = NULL,
  pilotIndices = 1:10,
  verbose = FALSE
)
}
\arguments{
\item{ExperimentObj}{A SummarizedExperiment object generated from
getSampleTileMatrix, chromVAR, or other.}

\item{cellPopulation}{A single cell population on which to run this pilot
model}

\item{modelFormula}{The formula to use with lmerTest::lmer, in the
format (exp ~ factors). All factors must be found in column names
of the ExperimentObj metadata.}

\item{pilotIndices}{A vector of integers defining the subset of
the ExperimentObj matrix. Default is 1:10.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
modelList a list of outputs from lmerTest::lmer
}
\description{
\code{pilotLMEM} Runs linear mixed-effects modeling for
  continuous, non-zero inflated data using \code{\link[lmerTest]{lmer}}
}
