% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callOpenTiles.R
\docType{methods}
\name{callOpenTiles}
\alias{callOpenTiles}
\alias{callOpenTiles,GRangesList-method}
\alias{callOpenTiles,list-method}
\alias{.callOpenTiles_ArchR}
\alias{callOpenTiles,ArchRProject-method}
\title{\code{callOpenTiles} Perform peak-calling on a set of fragments or an
  ArchR Project.}
\usage{
callOpenTiles(
  ATACFragments,
  cellColData,
  blackList,
  genome,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  generalizeStudySignal = FALSE,
  cellCol = "RG",
  TxDb,
  OrgDb,
  outDir,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)

\S4method{callOpenTiles}{GRangesList}(
  ATACFragments,
  cellColData,
  blackList,
  genome,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  generalizeStudySignal = FALSE,
  cellCol = "RG",
  TxDb,
  OrgDb,
  outDir,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)

\S4method{callOpenTiles}{list}(
  ATACFragments,
  cellColData,
  blackList,
  genome,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  generalizeStudySignal = FALSE,
  cellCol = "RG",
  TxDb,
  OrgDb,
  outDir,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)

.callOpenTiles_ArchR(
  ATACFragments,
  cellPopLabel,
  cellPopulations = "ALL",
  studySignal = NULL,
  generalizeStudySignal = FALSE,
  TxDb,
  OrgDb,
  outDir = NULL,
  numCores = 30,
  verbose = FALSE,
  force = FALSE
)
}
\arguments{
\item{ATACFragments}{an ArchR Project, or a GRangesList of fragments. Each
GRanges in the GRanges list must have unique cell IDs in the column given
by 'cellCol'.}

\item{cellColData}{A DataFrame containing cell-level metadata. This must
contain both a column 'Sample' with unique sample IDs and the column
specified by 'cellPopLabel'.}

\item{blackList}{A GRanges of blacklisted regions}

\item{genome}{A BSgenome object, or the full name of an installed BSgenome
data package, or a short string specifying the name of an NCBI assembly
(e.g. "GRCh38", "TAIR10.1", etc...) or UCSC genome (e.g. "hg38", "bosTau9",
"galGal6", "ce11", etc...). The supplied short string must refer
unambiguously to an installed BSgenome data package. See
\link[BSgenome]{getBSgenome}.}

\item{cellPopLabel}{string indicating which column in the ArchRProject
metadata contains the cell population label.}

\item{cellPopulations}{vector of strings. Cell subsets for which to call
peaks. This list of group names must be identical to names that appear in
the ArchRProject metadata.  Optional, if cellPopulations='ALL', then peak
calling is done on all cell populations in the ArchR project metadata.
Default is 'ALL'.}

\item{studySignal}{The median signal (number of fragments) in your study. If
not set, this will be calculated using the input ArchR project but relies
on the assumption that the ArchR project encompasses your whole study (i.e.
is not a subset).}

\item{generalizeStudySignal}{If `studySignal` is not provided, calculate the
signal as the mean of the mean & median number of fragments for of
individual samples within each cell population. This may improve MOCHA's
ability to generalize to datasets with XXXXXX #TODO. Default is FALSE, use
the median number of fragments.}

\item{cellCol}{The column in cellColData specifying unique cell ids or
barcodes. Default is "RG", the unique cell identifier used by ArchR.}

\item{TxDb}{The exact package name of a TxDb-class transcript annotation
package for your organism (e.g. "TxDb.Hsapiens.UCSC.hg38.refGene"). This
must be installed. See
\href{https://bioconductor.org/packages/release/data/annotation/}{
Bioconductor AnnotationData Packages}.}

\item{OrgDb}{The exact package name of a OrgDb-class genome wide annotation
package for your organism (e.g. "org.Hs.eg.db"). This must be installed.
See \href{https://bioconductor.org/packages/release/data/annotation/}{
Bioconductor AnnotationData Packages}}

\item{outDir}{is a string describing the output directory for coverage files.
Must be a complete directory string. With ArchR input, set outDir to NULL
to create a directory within the input ArchR project directory named MOCHA
for saving files.}

\item{numCores}{integer. Number of cores to parallelize peak-calling across
multiple cell populations.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}

\item{force}{Optional, whether to force creation of coverage files if they
already exist. Default is FALSE.}
}
\value{
tileResults A MultiAssayExperiment object containing ranged data for
  each tile
}
\description{
\code{callOpenTiles} is the main peak-calling function in MOCHA
  that serves as a wrapper function to call peaks provided a set of fragment
  files and an ArchR Project for meta-data purposes
}
\examples{
\dontrun{
# Starting from an ArchR Project:
tileResults <- MOCHA::callOpenTiles(
  ArchRProj = myArchRProj,
  cellPopLabel = "celltype_labeling",
  cellPopulations = "CD4",
  TxDb = "TxDb.Hsapiens.UCSC.hg38.refGene",
  OrgDb = "org.Hs.eg.db",
  numCores = 1
)
}
\donttest{
# Starting from GRangesList
if (
  requireNamespace("BSgenome.Hsapiens.UCSC.hg19") &&
    requireNamespace("TxDb.Hsapiens.UCSC.hg38.refGene") &&
    requireNamespace("org.Hs.eg.db")
) {
  tiles <- MOCHA::callOpenTiles(
    ATACFragments = MOCHA::exampleFragments,
    cellColData = MOCHA::exampleCellColData,
    blackList = MOCHA::exampleBlackList,
    genome = "BSgenome.Hsapiens.UCSC.hg19",
    TxDb = "TxDb.Hsapiens.UCSC.hg38.refGene",
    OrgDb = "org.Hs.eg.db",
    outDir = tempdir(),
    cellPopLabel = "Clusters",
    cellPopulations = c("C2", "C5"),
    numCores = 1
  )
}
}

}
