% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristicAnalysis.R
\name{getIntensityThreshold}
\alias{getIntensityThreshold}
\title{\code{getIntensityThreshold}}
\usage{
getIntensityThreshold(
  TSAM,
  cellPopulations = "all",
  type = "mean",
  returnPlots = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{TSAM}{a SummarizedExperiment object generated by MOCHA}

\item{cellPopulations}{vector of strings. Cell subsets found in the TSAM, or the word 'All' if all should be used.}

\item{type}{string. Describes the type of metric to be used. Options include median or mean.}

\item{returnPlots}{Boolean. Default is TRUE and returns a plot of}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
plot object
}
\description{
\code{getIntensityThreshold} takes the output of peak calling with
  callOpenTiles and creates sample-tile matrices containing the signal
  intensity at each tile.
}
