% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalarize_values.R
\name{scalarize_values}
\alias{scalarize_values}
\title{Scalarize values for MOEA/D}
\usage{
scalarize_values(normYs, W, B, aggfun)
}
\arguments{
\item{normYs}{List generated by \code{\link[=scale_objectives]{scale_objectives()}}, containing two matrices
of scaled objective values (\code{normYs$Y} and \code{normYs$Yt}) and two vectors,
containing the current estimates of the ideal (\code{normYs$minP}) and nadir
(\code{normYs$maxP}) points. See \code{\link[=scale_objectives]{scale_objectives()}} for details.}

\item{W}{matrix of weights, generated by \code{\link[=generate_weights]{generate_weights()}}.}

\item{B}{neighborhood matrix, generated by \code{\link[=define_neighborhood]{define_neighborhood()}}.}

\item{aggfun}{List containing the aggregation function parameters. See
Section \verb{Scalar Aggregation Functions} of the \code{\link[=moead]{moead()}} documentation for
details.}
}
\value{
\verb{[ (T+1) x N ]} matrix of scalarized performance values. Each column
contains the T scalarized performances of the candidate solutions in the
neighborhood of a given subproblem, plus the scalarized performance value
for the incumbent solution for that subproblem.
}
\description{
Perform scalarization for the MOEADr package.
}
\details{
This routine calculates the scalarized performance values for the MOEA/D.

The list of available scalarization methods can be generated using
\code{get_scalarization_methods()}
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

