% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\docType{data}
\name{blackisland}
\alias{blackisland}
\title{blackisland tagging data from a blacklip abalone population}
\format{
A data.frame of four columns
\describe{
  \item{dt}{the time between tagging and recapture, in years}
  \item{l1}{the shell length when tagged in mm}
  \item{l2}{the shell length at recapture in mm}
  \item{dl}{the growth increment between tagging and recapture
                in mm; there are zero values.}
}
}
\source{
Thanks to Dr Craig Mundy and the abalone team at the Institute of 
    Marine and Antarctic Studies, of the University of Tasmania for the use 
    of this data.
}
\description{
A 108 x 4 data.frame containing dt, the time
    in years between tagging and recapture, l1 the shell length 
    at tagging, and l2, the length at recapture, with the growth 
    increment, dl as the last column. This data can be used to 
    estimate the growth characteristics of 
    abalone from the Black Island site, which is on the south west 
    coast of Tasmania, Australia.  The mean time 
    interval between tagging and recapture is 1 year and 1 week,
    1.02 years, which reflects the practical problems of taking a 
    vessel around the bottom of Tasmania, where it is essential to
    wait on suitable weather for such sub-tidal field work.
}
\section{Subjects}{

 \itemize{
  \item Tagging data
  \item Estimation of individual growth
  \item Binomial likelihoods
  \item Faben's version of the von Bertalanffy curve
 }
}

\examples{
 data(blackisland)
 print(head(blackisland,20))
 oldpar <- par(no.readonly=TRUE)
 plot(blackisland$l1,blackisland$dl,type="p",pch=16,
 xlab="Initial Length mm",ylab="Growth Increment mm",
 panel.first=grid())
 abline(h=0)
 par(oldpar)
}
