% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{which.closest}
\alias{which.closest}
\title{which.closest find a number in a vector closest to a given value}
\usage{
which.closest(x, invect, index = TRUE)
}
\arguments{
\item{x}{the value to lookup}

\item{invect}{the vector in which to lookup the value x}

\item{index}{should the index be returned or the closest value; default=TRUE}
}
\value{
by default it returns the index in the vector of the value closest to
    the input value x
}
\description{
which.closest finds either the number in a vector which is
    closest to the input value or its index value
}
\examples{
vals <- rnorm(100,mean=5,sd=2)
pick <- which.closest(5.0,vals,index=TRUE) #closest to 5?
pick        # the index of the closest
vals[pick]  # its value
which.closest(5.0,vals,index=FALSE) # straight to the value
}
