% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.mscmt}
\alias{plot.mscmt}
\title{Plotting Results of MSCMT}
\usage{
\method{plot}{mscmt}(x, what, type = c("gaps", "comparison",
  "placebo.gaps", "placebo.data"), treatment.time, zero.line = TRUE,
  ylab, xlab = "Date", main, sub, col, lty, lwd, legend = TRUE,
  bw = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{"mscmt"}, usually obtained as
the result of a call to function \code{\link{mscmt}}.}

\item{what}{A character scalar. Name of the variable to be plotted. If 
missing, the (first) dependent variable will be used.}

\item{type}{A character scalar denoting the type of the plot containing 
either \code{"gaps"}, \code{"comparison"}, \code{"placebo.gaps"}, 
or \code{"placebo.data"}. 
Partial matching allowed, defaults to \code{"placebo.gaps"}, if results
of a placebo study are present, and to \code{"gaps"}, else.}

\item{treatment.time}{An optional numerical scalar. If not missing, a 
vertical dotted line at the given point in time is included in the plot. 
\code{treatment.time} is measured in years, but may as well be a decimal 
number to reflect treatment times different from January 1st.}

\item{zero.line}{A logical scalar. If \code{TRUE} (default), a horizontal
dotted line (at zero level) is plotted for \code{"gaps"} and \code{"placebo"}
plots.}

\item{ylab}{Optional label for the y-axis, automatically generated if 
missing.}

\item{xlab}{Optional label for the x-axis, defaults to \code{"Date"}.}

\item{main}{Optional main title for the plot, automatically generated 
if missing.}

\item{sub}{Optional subtitle for the plot. If missing, the subtitle is 
generated automatically for \code{"comparison"} and \code{"gaps"} plots.}

\item{col}{Optional character vector with length corresponding to the number
of units. Contains the colours for the different units, automatically 
generated if missing.}

\item{lty}{Optional numerical vector with length corresponding to the number
of units. Contains the line types for the different units, automatically 
generated if missing.}

\item{lwd}{Optional numerical vector with length corresponding to the number
of units. Contains the line widths for the different units, automatically 
generated if missing.}

\item{legend}{A logical scalar. If \code{TRUE} (default), a legend is 
included in the plot.}

\item{bw}{A logical scalar. If \code{FALSE} (default), the automatically 
generated colours and line types are optimized for a colour plot, 
if \code{TRUE}, the automatic colours and line types are set for a black and
white plot.}

\item{...}{Further optional parameters for the underlying 
\code{\link[graphics]{plot}} function.}
}
\value{
Nothing useful (function is called for its side effects).
}
\description{
\code{plot.mscmt} plots results of \code{mscmt}.
}
\details{
A unified basic plot function for gaps plots, comparison of treated and 
synthetic values, as well as plots for placebo studies.
Consider using \code{\link{ggplot.mscmt}} instead, which is the preferred
plot method and has more functionality than \code{\link{plot.mscmt}}.
}
