% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS2MOM.R
\name{SS2MOM}
\alias{SS2MOM}
\title{Import Stock Synthesis to multi-fleet 2-sex MOM}
\usage{
SS2MOM(
  SSdir,
  nsim = 48,
  proyears = 50,
  reps = 1,
  maxF = 3,
  seed = 1,
  interval = 1,
  pstar = 0.5,
  Obs = DLMtool::Generic_Obs,
  Imp = DLMtool::Perfect_Imp,
  silent = FALSE,
  Name = "MOM generated by SS2MOM",
  Source = "No Source provided",
  ...
)
}
\arguments{
\item{SSdir}{A folder with Stock Synthesis input and output files in it.}

\item{nsim}{The number of simulations to take for parameters with uncertainty (for OM@cpars custom parameters).}

\item{proyears}{The number of projection years for MSE}

\item{reps}{The number of stochastic replicates within each simulation in the operating model.}

\item{maxF}{The maximum allowable F in the operating model.}

\item{seed}{The random seed for the operating model.}

\item{interval}{The interval at which management procedures will update the management advice in \link{multiMSE}, e.g., 1 = annual updates.}

\item{pstar}{The percentile of the sample of the management recommendation for the MP/MMP.}

\item{Obs}{The observation model (class Obs).}

\item{Imp}{The implementation model (class Imp). This function does not update implementation parameters.}

\item{silent}{Whether to silence messages to the console.}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{...}{Arguments to pass to \link[r4ss]{SS_output}.}
}
\value{
An object of class \linkS4class{MOM}.
}
\description{
A function that uses the file location of a fitted SS3 model including input files to population the
various slots of an \linkS4class{MOM}. The function mainly populates the Stock (2-sex if needed) and Fleet (separate fleets with discarding behavior) portions
of the MOM; the user may still need to parameterize most of the observation and implementation portions of the MOM.
}
\note{
Currently tested on r4ss version 1.38.1 and SS 3.30.14.
}
\seealso{
\link{SS2Data} \link{SS2OM}
}
\author{
Q. Huynh
}
