% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn_MICE.R
\name{popdynMICE}
\alias{popdynMICE}
\title{Population dynamics for a MICE model (multiyear)}
\usage{
popdynMICE(
  qsx,
  qfracx,
  np,
  nf,
  nyears,
  nareas,
  maxage,
  Nx,
  VFx,
  FretAx,
  Effind,
  movx,
  Spat_targ,
  M_ageArrayx,
  Mat_agex,
  Fec_agex,
  Asizex,
  WatAgex,
  Len_agex,
  Karrayx,
  Linfarrayx,
  t0arrayx,
  Marrayx,
  R0x,
  R0ax,
  SSBpRx,
  hsx,
  aRx,
  bRx,
  ax,
  bx,
  Perrx,
  SRrelx,
  Rel,
  SexPars,
  x,
  plusgroup,
  maxF,
  SSB0x
)
}
\arguments{
\item{qsx}{Total catchability}

\item{qfracx}{Vector \verb{[fleet]}, the fraction of total qs by fleet}

\item{np}{Integer, the number of stocks}

\item{nf}{Integer, number of fleets}

\item{nyears}{Integer, number of historical years (unfished til today)}

\item{nareas}{Integer, the number of spatial areas}

\item{maxage}{Integer, maximum modeled age}

\item{Nx}{Array \verb{[stock, age, year, area]} of stock numbers}

\item{VFx}{Array \verb{[fleet, age, year, area]} of the vulnerability curve}

\item{FretAx}{Array \verb{[fleet, age, year, area]} of the retention curve}

\item{Effind}{Array \verb{[fleet, year]} of effort}

\item{movx}{Array \verb{[stock,age,area,area]} of movement transitions}

\item{Spat_targ}{Matrix \verb{[stock, fleet]} of spatial targeting parameter
(0 evenly spatial distributed, 1 proportional to vulnerable biomass)}

\item{M_ageArrayx}{Array \verb{[stock, age,year]} of Natural mortality rate at age}

\item{Mat_agex}{Array \verb{[stock, age, year]} of maturity (spawning fraction) at age}

\item{Fec_agex}{Array \verb{[stock, age, year]} of female spawning weight (fecundity) at age}

\item{Asizex}{Array \verb{[stock, area]} Area size}

\item{WatAgex}{Array of weight-at-age}

\item{Len_agex}{Array of length-at-age}

\item{Karrayx}{Array of von B growth parameter K}

\item{Linfarrayx}{Array of von B asymptotic length parameter Linf}

\item{t0arrayx}{Array ofvon B theoretical age at zero length (t0)}

\item{Marrayx}{Array of mature natural mortality rate}

\item{R0x}{Vector \verb{[stock]} unfished recruitment}

\item{R0ax}{Matrix \verb{[stock, area]} unfished recruitment by area}

\item{SSBpRx}{Matrix \verb{[stock, area]} spawning biomass per recruit by area}

\item{hsx}{Vector \verb{[stock]} steepness of the stock recruitment curve}

\item{aRx}{Vector \verb{[stock]} stock recruitment parameter alpha (for Ricker curve)}

\item{bRx}{Vector \verb{[stock]} stock recruitment parameter beta (for Ricker curve)}

\item{ax}{Vector \verb{[stock]} weight-length parameter a W=aL^b}

\item{bx}{Vector \verb{[stock]} weight-length parameter b W=aL^b}

\item{Perrx}{Matrix \verb{[stock, year]} process error - the lognormal factor for recruitment strength}

\item{SRrelx}{Integer vector \verb{[stock]} the form of the stock recruitment
relationship (1 = Beverton-Holt, 2= Ricker)}

\item{Rel}{A list of inter-stock relationships see slot Rel of MOM object class}

\item{SexPars}{A list of sex-specific relationships (SSBfrom, stock_age)}

\item{x}{Integer the simulation number}

\item{plusgroup}{Numeric vector. Use plus-group (1) or not (0)}

\item{maxF}{maximum F}

\item{SSB0x}{SSB0 for this simulation}
}
\description{
Calls popdynOneMICE iteratively to reconstruct a time series given MICE model inputs
}
\author{
T.Carruthers
}
\keyword{internal}
