% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdev.R
\name{gdev}
\alias{gdev}
\title{General Deviation}
\usage{
gdev(x, var1, var2, type = "rel", ref = NULL)
}
\arguments{
\item{x}{a data frame.}

\item{var1}{name of the numerator variable in x.}

\item{var2}{name of the denominator variable in x.}

\item{type}{type of deviation; "rel" for relative deviation, "abs" for 
absolute deviation (see Details).}

\item{ref}{ratio of reference; if NULL, the ratio of reference is the one of 
the whole study area (\code{sum(var1) / sum(var2)}).}
}
\value{
A vector is returned.
}
\description{
This function computes the deviation between regional ratios 
and a ratio of reference. 
Each elementary unit's value will be compared to a global value.
}
\details{
The relative global deviation is the ratio between var1/var2 and ref
(\code{100 * (var1 / var2) / ref}). Values greater than 100 indicate that the 
unit ratio is greater than the ratio of reference. Values lower than 100 
indicate that the unit ratio is lower than the ratio of reference.\cr
The absolute global deviation is the amount of numerator that could be moved 
to obtain the ratio of reference on all units.
}
\examples{
# load data
data("GrandParisMetropole")
# compute absolute global deviation
com$gdevabs <- gdev(x = com, var1 = "INC", var2 = "TH", type = "abs")
# compute relative global deviation
com$gdevrel <- gdev(x = com, var1 = "INC", var2 = "TH", type = "rel")

# Deviations maps
if(require('cartography')){
  # set graphical parameters
  par(mar = c(0,0,1.2,0))
  # set breaks
  bks <- c(min(com$gdevrel),50,75,100,125,150,max(com$gdevrel))
  cols <- carto.pal(pal1 = "blue.pal", n1 = 3,
                    pal2 = "wine.pal", n2 = 3)
  # plot a choropleth map of the relative global deviation
  choroLayer(spdf = com.spdf, df = com, var = "gdevrel",
             legend.pos = "topleft",
             legend.title.txt = "Relative Deviation",
             breaks = bks, border = NA,
             col = cols)
  # add symbols proportional to the absolute general deviation
  propSymbolsLayer(spdf = com.spdf, df = com, var = "gdevabs",
                   legend.pos = "left",legend.values.rnd = -2,
                   legend.title.txt = "Absolute Deviation",
                   col = "#ff000050",col2 = "#0000ff50",
                   legend.style = "e", inches = 0.2,
                   breakval = 0)
  # add EPT boundaries
  plot(ept.spdf, add=TRUE)
  # add a layout
  layoutLayer(title = "General Deviation (reference: Grand Paris Metropole)",
              sources = "GEOFLA® 2015 v2.1, Apur, impots.gouv.fr", 
              north = TRUE,
              author = "MTA")
}
}
