% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mas.R
\name{mas}
\alias{mas}
\title{Multiscalar Absolute Synthesis}
\usage{
mas(x, gdevabs, tdevabs, sdevabs, num)
}
\arguments{
\item{x}{a sf object or a dataframe including gdevabs, tdevabs, sdevabs and num columns.}

\item{gdevabs}{name of the general absolute deviation variable in x.}

\item{tdevabs}{name of the territorial absolute deviation variable in x.}

\item{sdevabs}{name of the spatial absolute deviation variable in x.}

\item{num}{name of the numerator used for computing the 3 absolute deviations in x.}
}
\value{
A dataframe including the mass of numerator to redistribue to reach a perfect equilibrium 
according to the 3 contexts, expressed in numerator measure unit and as a share of the numerator mass.
}
\description{
This function sums the total amount of redistributions according to the three absolute 
deviations (global, territorial, spatial).
}
\examples{
# Load data
library(sf)
com <- st_read(system.file("metroparis.gpkg", package = "MTA"), layer = "com", quiet = TRUE)

# general absolute deviation 
com$gdevabs <- gdev(x = com, var1 = "INC",var2 = "TH", type = "abs")

# Territorial absolute deviation calculation
com$mdevabs <- tdev(x = com,  var1 = "INC", var2 = "TH", type = "abs",
                    key = "LIBEPT")

# Local absolute deviation calculation redistribution 
com$ldevabs <- sdev(x = com, xid = "DEPCOM", var1 = "INC", var2 = "TH",
                    order = 1, type = "abs")

# Compute the synthesis DataFrame (absolute deviations)
mas(x = com, 
    gdevabs = "gdevabs", 
    tdevabs = "mdevabs",
    sdevabs = "ldevabs",
    num = "INC") 
}
