% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Huber.R
\name{huber.reg}
\alias{huber.reg}
\title{Huber estimation for linear regression}
\usage{
huber.reg(y, X, beta.ini, alpha, intercept = FALSE)
}
\arguments{
\item{y}{the response vector}

\item{X}{design matrix}

\item{beta.ini}{initial value of estimates, could be from OLS.}

\item{alpha}{1/alpha is the huber tuning parameter delta. Larger alpha results in smaller portion of squared loss.}

\item{intercept}{logical input that indicates if intercept needs to be estimated. Default is FALSE.}
}
\value{
\item{beta}{the regression coefficient estimates}
\item{fitted.value}{predicted response}
\item{iter.steps}{iteration steps.}
}
\description{
This function produces Huber estimates for linear regression. Initial estimates is required.
Currently, the function does not support automatic selection of huber tuning parameter.
}
\examples{
set.seed(2017)
n=200; d=4
X=matrix(rnorm(n*d), nrow=n, ncol=d)
beta=c(1, -1, 2, -2)
y=-2+X\%*\%beta+c(rnorm(150), rnorm(30,10,10), rnorm(20,0,100))
beta0=beta.ls=lm(y~X)$coeff
beta.huber=huber.reg(y, X, beta0, 2, intercept=TRUE)$beta
cbind(c(-2,beta), beta.ls, beta.huber)
}
