% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doornik_hansen.R
\name{doornik_hansen}
\alias{doornik_hansen}
\title{Doornik-Hansen Test for Multivariate Normality}
\usage{
doornik_hansen(data)
}
\arguments{
\item{data}{A numeric matrix or data frame with observations in rows and variables in columns.}
}
\value{
A data frame with one row containing the following columns:
\code{Test}, the name of the test ("Doornik-Hansen");
\code{Statistic}, the value of the test statistic;
\code{df}, the degrees of freedom;
and \code{p.value}, the p-value from a chi-square approximation.
}
\description{
Performs the Doornik–Hansen omnibus test by transforming the data to approximate normality
and combining skewness and kurtosis measures to test for multivariate normality.
}
\examples{
\dontrun{
data <- iris[1:50, 1:4]
dh_result <- doornik_hansen(data)
dh_result
}

}
