\name{Cross-validation of the FBED with LMM}
\alias{cv.fbed.lmm.reg}
\title{
Cross-validation of the FBED with LMM
}

\description{
Cross-validation of the FBED with LMM.
}

\usage{
cv.fbed.lmm.reg(target, dataset, id, prior = NULL, kfolds = 10, 
                folds = NULL, alphas = c(0.01, 0.05), ks = 0:2) 
}
\arguments{
\item{target}{
The class variable. This must be a numerical vector with continuous data.
}
\item{dataset}{
The dataset; provide a numerical a matrix (columns = variables, rows = observations).
}
\item{id}{
This is a numerical vector of the same size as target denoting the groups or the subjects. 
}
\item{prior}{
If you have prior knowledge of some variables that must be in the variable selection phase add them here. This an be a vector (if you have one variable) or a matrix (if you more variables). This does not work during the backward phase at the moment.
}
\item{kfolds}{
The number of the folds in the k-fold Cross Validation (integer).
}
\item{folds}{
The folds of the data to use (a list generated by the function generateCVRuns {TunePareto}). If NULL the folds are created internally with the same function.
}
\item{alphas}{
A vector of significance levels to be tested.
}
\item{ks}{
A vector of K values to be tested.
}
}

\details{
The function performs cross-validation for the FBED agortihm with clustered data using the linear mixed model. The k-folds cross-validation is on clusters. Instead of leaving observations, clusters are left aside each time. 
}

\value{
A list including:

list(vars = vars, cv = cv, perf = perf, best = best, runtime = runtime)

\item{vars}{
An array with the number of selected variables for each combination of significance level and value of K.
}
\item{cv}{
An array with the number of selected variables for each combination of significance level and value of K.
}
\item{perf}{
A matrix with the average performance each combination of significance level and value of K.
}
\item{best}{
The best significance level and value of K.
}
\item{runtime}{
The runtime required.
}
}

\references{
Fang Y. (2011). Asymptotic equivalence between cross-validations and Akaike information criteria in mixed-effects models. Journal of data science, 9(1), 15-21.

Eugene Demidenko (2013). Mixed Models: Theory and Applications with R, 2nd Edition. New Jersey: Wiley \& Sons.

Borboudakis G. and Tsamardinos I. (2019). Forward-backward selection with early dropping. Journal of Machine Learning Research, 20(8): 1-39.
}


\author{
Michail Tsagris
  
R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}
}

\seealso{
\code{ \link{fbed.glmm.reg}, \link{fbed.gee.reg}, \link{MMPC.glmm} }
}

\examples{
\dontrun{
require(lme4)
data(sleepstudy)
reaction <- sleepstudy$Reaction
subject <- sleepstudy$Subject
x1 <- sleepstudy$Days
x <- matrix(rnorm(180 * 200),ncol = 200) ## unrelated predictor variables
x <- cbind(x1, x)
m <- cv.fbed.lmm.reg(reaction, x, subject) 
}
}

