% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_steps}
\alias{expand_steps}
\title{Recipe Step Parameters Expansion}
\usage{
expand_steps(..., random = FALSE)
}
\arguments{
\item{...}{one or more lists containing parameter values over which to create
the grid.  For each list an argument name should be given as the \code{id}
of the \link[recipes]{recipe} step to which it corresponds.}

\item{random}{number of points to be randomly sampled from the parameter grid
or \code{FALSE} if all points are to be returned.}
}
\value{
\code{RecipeGrid} class object that inherits from \code{data.frame}.
}
\description{
Create a grid of parameter values from all combinations of lists supplied for
steps of a preprocessing recipe.
}
\examples{
library(recipes)
library(MASS)

rec <- recipe(medv ~ ., data = Boston) \%>\%
  step_corr(all_numeric(), -all_outcomes(), id = "corr") \%>\%
  step_pca(all_numeric(), -all_outcomes(), id = "pca")

expand_steps(
  corr = list(threshold = c(0.8, 0.9),
              method = c("pearson", "spearman")),
  pca = list(num_comp = 1:3)
)

}
\seealso{
\code{\link{TunedRecipe}}
}
