% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradients-likelihoods.R
\name{gr_GP}
\alias{gr_GP}
\title{Gradient of the logLikelihood of a Gaussian Process}
\usage{
gr_GP(hp, db, mean, kern, post_cov, pen_diag)
}
\arguments{
\item{hp}{A tibble, data frame or named vector containing hyper-parameters.}

\item{db}{A tibble containing the values we want to compute the logL on.
Required columns: Input, Output. Additional covariate columns are allowed.}

\item{mean}{A vector, specifying the mean of the GP at the reference inputs.}

\item{kern}{A kernel function.}

\item{post_cov}{(optional) A matrix, corresponding to covariance parameter of
the hyper-posterior. Used to compute the hyper-prior distribution of a new
individual in Magma.}

\item{pen_diag}{A jitter term that is added to the covariance matrix to avoid
numerical issues when inverting, in cases of nearly singular matrices.}
}
\value{
A named vector, corresponding to the value of the hyper-parameters
gradients for the Gaussian log-Likelihood (where the covariance can be the
sum of the individual and the hyper-posterior's mean process covariances).
}
\description{
Gradient of the logLikelihood of a Gaussian Process
}
\examples{
TRUE
}
\keyword{internal}
