% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializeMazamaSpatialUtils.R
\name{initializeMazamaSpatialUtils}
\alias{initializeMazamaSpatialUtils}
\title{Initialize MazamaSpatialUtils package}
\usage{
initializeMazamaSpatialUtils(spatialDataDir = "~/Data/Spatial")
}
\arguments{
\item{spatialDataDir}{Directory where \pkg{MazamaSpatialUtils} datasets are found.}
}
\description{
Convenience function that wraps:

\preformatted{
  MazamaSpatialUtils::setSpatialDataDir("~/Data/Spatial")
  MazamaSpatialUtils::loadSpatialData("EEZCountries.rda")
.  MazamaSpatialUtils::loadSpatialData("OSMTimezones.rda")
  MazamaSpatialUtils::loadSpatialData("NaturalEarthAdm1.rda")
  MazamaSpatialUtils::loadSpatialData("USCensusCounties.rda")
}

If spatial data has not yet been installed, an error is returned with an
extended message detailing how to install the appropriate data.
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

  # Set up directory for spatial data
  spatialDataDir <- tempdir() # typically "~/Data/Spatial"
  MazamaSpatialUtils::setSpatialDataDir(spatialDataDir)

  exists("NaturalEarthAdm1")
  initializeMazamaSpatialUtils(spatialDataDir)
  exists("NaturalEarthAdm1")
  class(NaturalEarthAdm1)
  
}, silent = FALSE)
}
}
