% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_US_stateObesity}
\alias{example_US_stateObesity}
\title{Example state obesity dataset}
\format{
A tibble with 52 rows and 3 columns of data.
}
\usage{
example_US_stateObesity
}
\description{
The \code{example_US_stateObesity} dataset provides a small
state dataset to use in code examples. The code for creating it demonstrates
creation of a dataest that is compatible with \code{stateMap()}.

This dataset was generated on 2020-06-09 by running:

\preformatted{
library(dplyr)
library(MazamaSpatialUtils)

fileUrl <- paste0("http://data-lakecountyil.opendata.arcgis.com/datasets/",
                  "3e0c1eb04e5c48b3be9040b0589d3ccf_8.csv")

col_names <- c("FID", "stateName", "obesityRate", "SHAPE_Length", "SHAPE_Area")
col_types = "icddd"

outputColumns <- c("stateCode", "stateName", "obesityRate")

# After a little trial and error, the following works well:

example_US_stateObesity <-
  readr::read_csv(
    file = fileUrl,
    skip = 1,                    # Skip the header line
    col_names = col_names,
    col_types = col_types
  ) \%>\%
  dplyr::mutate(
    stateCode = MazamaSpatialUtils::US_stateNameToCode(stateName)
  ) \%>\%
  dplyr::select(!!outputColumns)

save(example_US_stateObesity, file = "data/example_US_stateObesity.rda")
}
}
\keyword{datasets}
