\name{GenerateReport}
\alias{GenerateReport}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Clinical Scenario Evaluation Report
}
\description{
This function generates a Word-based report to present a detailed description of the simulation parameters (data, analysis and evaluation models) and results.
}
\usage{
GenerateReport(presentation.model, cse.results, report.filename, report.template = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{presentation.model}{
defines a \code{PresentationModel} object.
}
  \item{cse.results}{
defines a \code{CSE} object returned by the \code{CSE} function.
}
  \item{report.filename}{
defines the output filename of the word-based document generated.
}
  \item{report.template}{
defines a word-based template (optional).
}
}
\details{
This function requires the package \code{ReporteRs}. A customized template can be specified in the argument \code{report.template} (optional), which consists in a Word document to place in the working directory folder.
}

\references{
\url{http://biopharmnet.com/mediana}
}

\seealso{
See Also \code{\link{CSE}} and \code{\link{PresentationModel}}.
}
\examples{
\dontrun{
# Outcome parameter set 1
outcome1.placebo = parameters(mean = 0, sd = 70)
outcome1.treatment = parameters(mean = 40, sd = 70)

# Outcome parameter set 2
outcome2.placebo = parameters(mean = 0, sd = 70)
outcome2.treatment = parameters(mean = 50, sd = 70)

# Data model
case.study1.data.model = DataModel() +
  OutcomeDist(outcome.dist = "NormalDist") +
  SampleSize(c(50, 55, 60, 65, 70)) +
  Sample(id = "Placebo",
         outcome.par = parameters(outcome1.placebo, outcome2.placebo)) +
  Sample(id = "Treatment",
         outcome.par = parameters(outcome1.treatment, outcome2.treatment))


# Analysis model
case.study1.analysis.model = AnalysisModel() +
  Test(id = "Placebo vs treatment",
       samples = samples("Placebo", "Treatment"),
       method = "TTest")

# Evaluation model
case.study1.evaluation.model = EvaluationModel() +
  Criterion(id = "Marginal power",
            method = "MarginalPower",
            tests = tests("Placebo vs treatment"),
            labels = c("Placebo vs treatment"),
            par = parameters(alpha = 0.025))

# Simulation Parameters
case.study1.sim.parameters = SimParameters(n.sims = 1000, proc.load = 2, seed = 42938001)

# Perform clinical scenario evaluation
case.study1.results = CSE(case.study1.data.model,
                          case.study1.analysis.model,
                          case.study1.evaluation.model,
                          case.study1.sim.parameters)


# Reporting
case.study1.presentation.model = PresentationModel() +
  Section(by = "outcome.parameter") +
  Table(by = "sample.size") +
  CustomLabel(param = "sample.size",
              label= paste0("N = ",c(50, 55, 60, 65, 70))) +
  CustomLabel(param = "outcome.parameter",
              label=c("Standard 1", "Standard 2"))

# Report Generation
GenerateReport(presentation.model = case.study1.presentation.model,
               cse.results = case.study1.results,
               report.filename = "Case study 1 (normally distributed endpoint).docx")

}
}
