\name{ADTreatSelExample2}
\alias{ADTreatSelExample2}
\title{
Simulation-based design of an adaptive trial with treatment selection (binary endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial with a binary primary efficacy endpoint. This endpoint represents a success rate and thus a higher proportion corresponds to a more favorable outcome. The efficacy and safety profiles of three treatments, e.g., three doses of an experimental treatment, will be evaluated in this trial compared to a control. An adaptive design with two interim analyses will be employed in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial). The following decision rules will be applied at the interim looks:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). A treatment arm may be dropped due to futility if the treatment-specific conditional power is too low. The trial will be terminated for futility if all treatment arms are dropped.
    \item Treatment selection rule will be applied at the second interim analysis (IA2). The best performing treatment will be selected for the final analysis (FA) and the remaining treatments will be dropped at this interim analysis.
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 150 enrolled patients per trial arm will be utilized in the trial.
    \item The patient dropout rate at the end of the treatment period is equal to 10\%.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%. 
}
The futility threshold for each treatment arm at IA1 is set to 15\%. The response rates for the primary endpoint are assumed to be 10\% in the control arm and 25\% in each treatment arm.

Key operating characteristics of this adaptive design with a treatment selection option at the second interim look will be evaluated using the \code{\link{ADTreatSel}} function based on 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report for this adaptive design can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ADTreatSelApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ADTreatSel}}, \code{\link{ADTreatSelExample1}}, \code{\link{ADTreatSelExample3}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Binary"

# Direction of favorable outcome
parameters$direction = "Higher"

# Number of enrolled patients (control, three treatments)
parameters$sample_size = c(150, 150, 150, 150)

# Patient dropout rate
parameters$dropout_rate = 0.1

# Response rate in the control arm 
parameters$control_rate = 0.1

# Response rates in the treatment arms 
parameters$treatment_rate = c(0.25, 0.25, 0.25)

# Information fractions at IA1, IA2, FA
parameters$info_frac = c(0.4, 0.6, 1)

# Futility threshold for conditional power at IA1
parameters$futility_threshold = 0.15

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations
parameters$nsims = 1000

# Run simulations to compute operating characteristics
results = ADTreatSel(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ADTreatSel Binary endpoint.docx", fileext=".docx"))
}