% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2rcreate.R
\name{computeDosage}
\alias{computeDosage}
\title{computeDosage function}
\usage{
computeDosage(markers_arg, range_arg, envir)
}
\arguments{
\item{markers_arg}{a data.frame with the following 5 observations:
\describe{
\item{locus_link}{is the ordinal ranking of this marker among all loci}
\item{locus_link_fill}{is the position of corresponding genotype data in the
\emph{unified_genotype_table}}
\item{MarkerName}{is the text name of the marker}
\item{chromosome}{is the integer chromosome number}
\item{position}{is the integer base pair position of marker}
}}

\item{range_arg}{one row of a ranges_arg.  The latter is a data frame of at least three
integer columns.  The columns indicate a range:
a chromosome number, a start base pair value, and an end base pair value.}

\item{envir}{'environment' containing SQLite database and other globals especially the
phenotype_table, \code{phe}.}
}
\value{
a matrix of samples X markers for all the markers that have nonzero changes.
}
\description{
Convert the genotypesraw() allele patterns of 0x10001, 0x10002 (or 0x20001), 0x20002, 0
 to the numbers 0, 1, 2, 9 for each marker. (Reverse, the order iff allele "1" has the
 minor allele frequency.)
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_famSKATRC(db, verbose = TRUE)
dimDosage = function(m, r, e) {print(dim(computeDosage(m, r, e)))}
applyFnToRanges(dimDosage, ENV$refRanges[50:60, ], ENV$refIndices, envir=ENV)
# This will use return dosage matrices for the markers in the ranges 50 - 60,
# but is basically ignores the results.

}
\seealso{
\code{\link{DOfamSKATRC}}
}
