% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini_coefficient.R
\name{gini_coefficient}
\alias{gini_coefficient}
\title{Gini coefficient}
\usage{
gini_coefficient(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values (0 or 1).}

\item{predicted}{Predicted values (not necessarly between 0 and 1).}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed by other methods.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted Gini coefficient, obtained as 2 * AUC - 1. Up to ties in \code{predicted} equivalent to Somer's D.
}
\examples{
gini_coefficient(c(0, 0, 1, 1), 2 * c(0.1, 0.1, 0.9, 0.8))
gini_coefficient(c(0, 0, 1, 1), c(0.1, 0.6, 0.9, 0.5))
gini_coefficient(c(0, 0, 1, 1), c(0.1, 0.6, 0.9, 0.5), w = 1:4)

}
\seealso{
\code{\link{AUC}}.
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
