% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div_test.R
\name{glmutli_pq}
\alias{glmutli_pq}
\title{Automated model selection and multimodel inference with (G)LMs for phyloseq}
\usage{
glmutli_pq(
  physeq,
  formula,
  fitfunction = "lm",
  hill_scales = c(0, 1, 2),
  aic_step = 2,
  confsetsize = 100,
  plotty = FALSE,
  level = 1,
  method = "h",
  crit = "aicc",
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{formula}{(required) a formula for \code{\link[glmulti:glmulti]{glmulti::glmulti()}}
Variables must be present in the \code{physeq@sam_data} slot or be one
of hill number defined in hill_scales or the variable Abundance which
refer to the number of sequences per sample.}

\item{fitfunction}{(default "lm")}

\item{hill_scales}{(a vector of integer) The list of q values to compute
the hill number H^q. If Null, no hill number are computed. Default value
compute the Hill number 0 (Species richness), the Hill number 1
(exponential of Shannon Index) and the Hill number 2 (inverse of Simpson
Index).}

\item{aic_step}{The value between AIC scores to cut for.}

\item{confsetsize}{The number of models to be looked for, i.e. the size of the returned confidence set.}

\item{plotty}{(logical) Whether to plot the progress of the IC profile when running.}

\item{level}{If 1, only main effects (terms of order 1) are used to build
the candidate set. If 2, pairwise interactions are also used (higher order
interactions are currently ignored)}

\item{method}{The method to be used to explore the candidate set of models.
If "h" (default) an exhaustive screening is undertaken.
If "g" the genetic algorithm is employed (recommended for large candidate sets).
If "l", a very fast exhaustive branch-and-bound algorithm is used.
Package leaps must then be loaded, and this can only be applied to linear models
with covariates and no interactions. If "d", a simple summary of the candidate set
is printed, including the number of candidate models.}

\item{crit}{The Information Criterion to be used. Default is the small-sample corrected AIC (aicc).
This should be a function that accepts a fitted model as first argument.
Other provided functions are the classic AIC, the Bayes IC (bic), and QAIC/QAICc (qaic and qaicc).}

\item{...}{Additional arguments passed on to \code{\link[glmulti:glmulti]{glmulti::glmulti()}} function}
}
\value{
A data.frame summarizing the glmulti results with columns

-estimates
-unconditional_interval
-nb_model"
-importance
-alpha
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


See \code{\link[glmulti:glmulti]{glmulti::glmulti()}} for more information.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{\link[glmulti:glmulti]{glmulti::glmulti()}} if you
use this function.
}
\examples{
\donttest{
if (requireNamespace("glmulti")) {
  res_glmulti <-
    glmutli_pq(data_fungi, "Hill_0 ~ Hill_1 + Abundance + Time + Height", level = 1)
  res_glmulti
  res_glmulti_interaction <-
    glmutli_pq(data_fungi, "Hill_0 ~ Abundance + Time + Height", level = 2)
  res_glmulti
}
}
}
\seealso{
\code{\link[glmulti:glmulti]{glmulti::glmulti()}}
}
