% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{resolve_vector_ranks}
\alias{resolve_vector_ranks}
\title{Resolve conflict in a vector of taxonomy values}
\usage{
resolve_vector_ranks(
  vec,
  method = c("consensus", "rel_majority", "abs_majority", "preference", "unanimity"),
  strict = FALSE,
  second_method = c("consensus", "rel_majority", "abs_majority", "unanimity"),
  nb_agree_threshold = 1,
  preference_index = NULL,
  collapse_string = "/",
  replace_collapsed_rank_by_NA = FALSE
)
}
\arguments{
\item{vec}{(required) A vector of (taxonomic) values}

\item{method}{One of "consensus", "rel_majority", "abs_majority",
"preference" or "unanimity". See details.}

\item{strict}{(logical, default FALSE). If TRUE, NA are considered as
informative in resolving conflict (i.e. NA are taking into account in vote).
See details for more informations.}

\item{second_method}{One of "consensus", "rel_majority", "abs_majority",
or "unanimity". Only used if method = "preference". See details.}

\item{nb_agree_threshold}{(Int, default 1) The minimum number of times a
value must arise to be selected using vote. If 2, we only kept
taxonomic value present at least 2 times in the vector.}

\item{preference_index}{(Int. default NULL). Required if method="preference".
Useless for other method. The preference index is the index of the value in
vec for which we have a preference.}

\item{collapse_string}{(default '/'). The character to collapse taxonomic names
when multiple assignment is done.}

\item{replace_collapsed_rank_by_NA}{(logical, default FALSE). If set to TRUE,
all multiple assignments (all taxonomic rank including the 'collapse_string'
parameter) are replaced by NA.}
}
\value{
a vector of length 1 (one character value)
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Internally used in the function \code{\link[=assign_blastn]{assign_blastn()}} with method="vote"
and \code{\link[=assign_vsearch_lca]{assign_vsearch_lca()}} if \code{top_hits_only} is FALSE and \code{vote_algorithm} is not NULL.
}
\details{
\itemize{
\item \code{unanimity}: Only keep taxonomic value when all methods are agree
\itemize{
\item By default, the value with NA are not taking into account (strict=FALSE)
\item If \code{strict} , one NA in the row is sufficient to return a NA
}
\item \code{consensus}: Keep all taxonomic values separated by a '/' (separation can be modify using param \code{collapse_string})
\itemize{
\item If \code{strict} is TRUE, NA are also added to taxonomic vector such as 'Tiger/Cat/NA' instead of 'Tiger/Cat'
}
\item \code{abs_majority}: Keep the most found taxonomic value if it represent at least half of all taxonomic values.
\itemize{
\item If \code{strict} is TRUE, NA values are also count to determine the majority. For example, a vector of taxonomic rank c("A", "A", "A", "B", NA, NA) will give a value of 'A' if \code{strict} is FALSE (default) but a value of NA if \code{strict} is TRUE.
}
\item \code{rel_majority}: Keep the most found taxonomic value. In case of equality, apply a consensus strategy (collapse values separated by a '/') across the most found taxonomic values.
\itemize{
\item If \code{strict} is TRUE, NA are considered as a rank and can win the relative majority vote.  If \code{strict} is FALSE (default), NA are removed before ranking the taxonomic values.
\item \code{nb_agree_threshold}: Only keep return value when at least x methods agreed with x is set by parameter \code{nb_agree_threshold}. By default, (\code{nb_agree_threshold} = 1): a majority of one is enough.
}
\item \code{preference}: Keep the value from a preferred column.
\itemize{
\item when the value is NA in the preferred column, apply a second strategy (by default \code{consensus}) to the other column (parameter \code{second_method}). Note that the parameters \code{strict} and \code{nb_agree_threshold} are used for the second_method consensus.
}
}
}
\examples{

resolve_vector_ranks(c("A"))
resolve_vector_ranks(c("A"),
  method = "preference",
  preference_index = 1
)
resolve_vector_ranks(c("A"), method = "abs_majority")
resolve_vector_ranks(c("A"), method = "rel_majority")
resolve_vector_ranks(c("A"),
  method = "rel_majority",
  nb_agree_threshold = 2
)
resolve_vector_ranks(c("A"), method = "unanimity")

resolve_vector_ranks(c("A", "A", "A"))
resolve_vector_ranks(c("A", "A", "A"),
  method = "preference",
  preference_index = 1
)
resolve_vector_ranks(c("A", "A", "A"), method = "abs_majority")
resolve_vector_ranks(c("A", "A", "A"), method = "rel_majority")
resolve_vector_ranks(c("A", "A", "A"), method = "unanimity")

resolve_vector_ranks(c(NA, NA, NA))
resolve_vector_ranks(c(NA, NA, NA),
  method = "preference",
  preference_index = 1
)
resolve_vector_ranks(c(NA, NA, NA), method = "abs_majority")
resolve_vector_ranks(c(NA, NA, NA), method = "rel_majority")
resolve_vector_ranks(c(NA, NA, NA), method = "unanimity")

resolve_vector_ranks(c("A", "A", NA))
resolve_vector_ranks(c("A", "A", NA),
  method = "preference",
  preference_index = 1
)
resolve_vector_ranks(c("A", "A", NA), method = "rel_majority")
resolve_vector_ranks(c("A", "A", NA), method = "abs_majority")
resolve_vector_ranks(c("A", "A", NA, NA),
  method = "abs_majority",
  strict = FALSE
)
resolve_vector_ranks(c("A", "A", NA, NA),
  method = "abs_majority",
  strict = TRUE
)
resolve_vector_ranks(c("A", "A", NA), method = "unanimity")
resolve_vector_ranks(c("A", "A", NA),
  method = "unanimity",
  strict = TRUE
)

resolve_vector_ranks(c("A", "B", NA))
resolve_vector_ranks(c("A", "B", NA), strict = TRUE)
resolve_vector_ranks(c("A", "B", NA),
  method = "preference",
  preference_index = 1
)
resolve_vector_ranks(c("A", "B", NA), method = "abs_majority")
resolve_vector_ranks(c("A", "B", NA), method = "rel_majority")
resolve_vector_ranks(c("A", "B", NA),
  method = "rel_majority",
  strict = TRUE
)
resolve_vector_ranks(c("A", "B", NA),
  method = "rel_majority",
  nb_agree_threshold = 2
)
resolve_vector_ranks(c("A", "B", NA), method = "unanimity")

resolve_vector_ranks(c("A", NA, NA))
resolve_vector_ranks(c("A", NA, NA), method = "rel_majority")
resolve_vector_ranks(c("A", NA, NA), method = "unanimity")
resolve_vector_ranks(c("A", NA, NA),
  method = "preference",
  preference_index = 1
)
resolve_vector_ranks(c("A", NA, NA),
  method = "preference",
  preference_index = 2
)
resolve_vector_ranks(c("A", NA, "B"),
  method = "preference",
  preference_index = 2
)
resolve_vector_ranks(c("A", NA, "B"),
  method = "preference",
  preference_index = 2, second_method = "abs_majority"
)

resolve_vector_ranks(c("A", "B", "B"))
resolve_vector_ranks(c("A", "B", "B"),
  method = "preference",
  preference_index = 1
)
resolve_vector_ranks(c("A", "B", "B"), method = "abs_majority")
resolve_vector_ranks(c("A", "B", "B"), method = "rel_majority")
resolve_vector_ranks(c("A", "B", "B"), method = "unanimity")


resolve_vector_ranks(c("A", "A", "A", "B", NA, NA))
resolve_vector_ranks(c("A", "A", "A", "B", NA, NA),
  strict = TRUE
)
resolve_vector_ranks(c("A", "A", "A", "B", NA, NA),
  method = "abs_majority"
)
resolve_vector_ranks(c("A", "A", "A", "B", NA, NA),
  method = "abs_majority",
  strict = TRUE
)
resolve_vector_ranks(c("A", "A", "A", "B", NA, NA),
  method = "preference", preference_index = 6, second_method = "abs_majority"
)
resolve_vector_ranks(c("A", "A", "A", "B", NA, NA, NA),
  method = "preference", preference_index = 6, second_method = "abs_majority"
)
resolve_vector_ranks(c("A", "A", "A", "B", NA, NA, NA),
  method = "preference", preference_index = 6, second_method = "abs_majority",
  strict = TRUE
)
}
\author{
Adrien Taudière
}
