% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deseq2_edgeR.R
\name{plot_edgeR_pq}
\alias{plot_edgeR_pq}
\title{Plot edgeR results for a phyloseq or a edgeR object.}
\usage{
plot_edgeR_pq(
  physeq,
  contrast = NULL,
  pval = 0.05,
  taxolev = "Genus",
  color_tax = "Phylum",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{contrast}{(required):This argument specifies what comparison
to extract from the object to build a results table.
See \code{\link[DESeq2]{results}} man page for more details.}

\item{pval}{(default: 0.05): the significance cutoff used for optimizing
the independent filtering. If the adjusted p-value cutoff (FDR) will be a
value other than 0.05, pval should be set to that value.}

\item{taxolev}{taxonomic level of interest}

\item{color_tax}{taxonomic level used for
color assignation}

\item{verbose}{(logical): whether the function print some
information during the computation}

\item{...}{Additional arguments passed on to \code{\link[edgeR]{exactTest}}
or \code{\link[ggplot2]{ggplot}}}
}
\value{
A \code{\link{ggplot}}2 plot representing edgeR results
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("GlobalPatterns", package = "phyloseq")
GP_archae <- subset_taxa(GlobalPatterns, GlobalPatterns@tax_table[, 1] == "Archaea")
\donttest{
plot_edgeR_pq(GP_archae, c("SampleType", "Soil", "Feces"),
  color_tax = "Kingdom"
)

plot_edgeR_pq(GP_archae, c("SampleType", "Soil", "Feces"),
  taxolev = "Class", color_tax = "Kingdom"
)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[edgeR]{exactTest}}

\code{\link{plot_deseq2_pq}}
}
\author{
Adrien Taudière
}
