% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsne_pq}
\alias{tsne_pq}
\title{Compute tSNE position of samples from a phyloseq object}
\usage{
tsne_pq(physeq, method = "bray", dims = 2, theta = 0, perplexity = 30, ...)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{method}{A method to calculate distance using \code{vegan::vegdist()} function}

\item{dims}{(Int) Output dimensionality (default: 2)}

\item{theta}{(Numeric) Speed/accuracy trade-off (increase for less accuracy), set to 0.0 for exact TSNE (default: 0.0 see details in the man page of \code{Rtsne::Rtsne}).}

\item{perplexity}{(Numeric) Perplexity parameter (should not be bigger than 3 * perplexity < nrow(X) - 1, see details in the man page of \code{Rtsne::Rtsne})}

\item{...}{: other arguments passed on to \code{Rtsne::Rtsne()}}
}
\value{
A list of element including the matrix Y containing the new representations for the objects.
See ?Rtsne::Rtsne() for more information
}
\description{
Compute tSNE position of samples from a phyloseq object
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
res_tsne <- tsne_pq(data_fungi)
\dontshow{\}) # examplesIf}
}
