% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ClusterGamma.R
\docType{class}
\name{ClusterGamma}
\alias{ClusterGamma}
\alias{ClusterGamma-class}
\title{Definition of the [\code{\linkS4class{ClusterGamma}}] class}
\description{
This class inherits from the [\code{\linkS4class{IClusterModelBase}}] class.
A gamma mixture model is a mixture model of the form:
\deqn{
  f({x}|\boldsymbol{\theta}) \\
  =\sum_{k=1}^K p_k \prod_{j=1}^d \gamma(x_j;a_{jk},b_{jk}) \\
   \quad {x} \in {R}^d.
}
}
\section{Slots}{

\describe{
\item{\code{component}}{A [\code{\linkS4class{ClusterGammaComponent}}] with the
shape and the scale of the component mixture model.}
}}
\examples{
getSlots("ClusterGamma")
  data(geyser)
  new("ClusterGamma", data=geyser)
}
\author{
Serge Iovleff
}
\seealso{
[\code{\linkS4class{IClusterModelBase}}] class
}

