% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data_two_iso.R
\name{plot_data_two_iso}
\alias{plot_data_two_iso}
\title{Plot biotracer data (2-D)}
\usage{
plot_data_two_iso(isotopes, mix, source, discr, filename, plot_save_pdf,
  plot_save_png)
}
\arguments{
\item{isotopes}{2-vector of biotracer indices to plot (e.g. c(1,2) or c(2,3))}

\item{mix}{output from \code{\link{load_mix_data}}}

\item{source}{output from \code{\link{load_source_data}}}

\item{discr}{output from \code{\link{load_discr_data}}}

\item{filename}{name of the plot file(s) to save (e.g. "isospace_plot")}

\item{plot_save_pdf}{T/F, save the plot(s) as a pdf?}

\item{plot_save_png}{T/F, save the plot(s) as a png?}
}
\description{
\code{plot_data_two_iso} creates a 2-D plot of mix and source tracer data and
saves the plot to a file in the working directory
}
\details{
An important detail is that \code{plot_data_two_iso} plots the raw mix data
and \emph{adds the TDF to the source data}, since this is the polygon that the
mixing model uses to determine proportions. The plotted source means are:
\deqn{\mu_source + \mu_discr}
The source error bars are +/- 1 standard deviation, \emph{calculated as a
combination of source and TDF variances:}
\deqn{\sqrt{\sigma^2_source + \sigma^2_discr}}

\code{plot_data_two_iso} looks for 'C', 'N', 'S', and 'O' in the biotracer column
headers and assumes they are stable isotopes, labeling the axes with, e.g.,
expression(paste(delta^13, "C (u2030)",sep="")).
}
\seealso{
\code{\link{plot_data}}
}
