% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixreg.R
\name{mixregRM2}
\alias{mixregRM2}
\title{Robust Mixture Regression with Thresholding-Embedded EM Algorithm for Penalized Estimation}
\usage{
mixregRM2(x, y, C = 2, ini = NULL, nstart = 20, tol = 1e-02, maxiter = 50,
          method = c("HARD", "SOFT"), sigma.const = 0.001, lambda = 0.001)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and p is the number of explanatory variables.
The intercept term will automatically be added to the data.}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{ini}{initial values for the parameters. Default is NULL, which obtains the initial values
using the \code{\link{mixreg}} function. It can be a list with the form of \code{list(pi, beta, sigma, gamma)}, where
\code{pi} is a vector of C mixing proportions,
\code{beta} is a C by (p + 1) matrix for regression coefficients of C components,
\code{sigma} is a vector of C standard deviations, and
\code{gamma} is a vector of C mean shift values.}

\item{nstart}{number of initializations to try. Default is 20.}

\item{tol}{stopping criteria (threshold value) for the EM algorithm. Default is 1e-02.}

\item{maxiter}{maximum number of iterations for the EM algorithm. Default is 50.}

\item{method}{character, determining which threshold method to use: \code{HARD} or \code{SOFT}.
Default is \code{HARD}. See details.}

\item{sigma.const}{constraint on the ratio of minimum and maximum values of sigma. Default is 0.001.}

\item{lambda}{tuning parameter in the penalty term. It can be found based on BIC. See Yu et al. (2017) for more details.}
}
\value{
A list containing the following elements:
\item{pi}{C-dimensional vector of estimated mixing proportions.}
\item{beta}{C by (p + 1) matrix of estimated regression coefficients.}
\item{sigma}{C-dimensional vector of estimated standard deviations.}
\item{gamma}{n-dimensional vector of estimated mean shift values.}
\item{posterior}{n by C matrix of posterior probabilities of each observation belonging to each component.}
\item{run}{total number of iterations after convergence.}
}
\description{
A robust mixture regression model that simultaneously conducts outlier detection and
robust parameter estimation. It uses a sparse, case-specific, and scale-dependent
mean-shift mixture model parameterization (Yu et al., 2017):
\deqn{f(y_i|\boldsymbol{x}_i,\boldsymbol{\theta},\boldsymbol{\gamma}_i) = \sum_{j=1}^C\pi_j\phi(y_i;\boldsymbol{x}^{\top}\boldsymbol{\beta}_j+\gamma_{ij}\sigma_j,\sigma_j^2),}
\eqn{i=1,\cdots,n}, where \eqn{C} is the number of components in the model,
\eqn{\boldsymbol{\theta}=(\pi_1,\boldsymbol{\beta}_1,\sigma_1,..,\pi_{C},\boldsymbol{\beta}_C,\sigma_C)^{\top}}
is the parameter to estimate,
and \eqn{\boldsymbol{\gamma}_i=(\gamma_{i1},...,\gamma_{iC})^{\top}} is a vector of mean-shift parameter for the ith observation.
}
\details{
The parameters are estimated by maximizing the corresponding penalized log-likelihood function using an EM algorithm.
The thresholding rule involes the estimation of \eqn{\gamma_{ij}} corresponding to different penalty:
\itemize{
\item Soft threshold: \eqn{\hat{\gamma}_{ij} = sgn(\epsilon_{ij})(|\epsilon_{ij}|-\lambda_{ij}^*)_{+})}, corresponding to the \eqn{l_1} penalty.
\item Hard threshold: \eqn{\hat{\gamma}_{ij} = \epsilon_{ij}I(|\epsilon_{ij}|>\lambda_{ij}^*))}, corresponding to the \eqn{l_0} penalty.
}

Here, \eqn{\epsilon_{ij} = (y_i-\boldsymbol{x}_i^{\top}\boldsymbol{\beta_j})/\sigma_j} and
\eqn{(\cdot)_{+}=\max(\cdot,0)}. Also, \eqn{\lambda_{ij}^*} is taken as \eqn{\lambda/p_{ij}^{(k+1)}} for soft threshold and
\eqn{\lambda/\sqrt{p_{ij}^{(k+1)}}} for hard threshold.
}
\examples{
data(tone)
y = tone$tuned
x = tone$stretchratio
k = 160
x[151:k] = 0
y[151:k] = 5
\donttest{est_RM2 = mixregRM2(x, y, lambda = 1)}
}
\references{
Yu, C., Yao, W., and Chen, K. (2017). A new method for robust mixture regression.
Canadian Journal of Statistics, 45(1), 77-94.
}
\seealso{
\code{\link{mixreg}} for initial value calculation.
}
