% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-TPS.R
\name{tps_arr}
\alias{tps_arr}
\title{Deformation 'vector field' using Thin Plate Splines}
\usage{
tps_arr(fr, to, amp = 1, grid = TRUE, over = 1.2, palette = col_summer,
  arr.nb = 200, arr.levels = 100, arr.len = 0.1, arr.ang = 20,
  arr.lwd = 0.75, arr.col = "grey50", poly = TRUE, shp = TRUE,
  shp.col = rep(NA, 2), shp.border = col_qual(2), shp.lwd = c(2, 2),
  shp.lty = c(1, 1), legend = TRUE, legend.text, ...)
}
\arguments{
\item{fr}{the reference \eqn{(x; y)} coordinates}

\item{to}{the target \eqn{(x; y)} coordinates}

\item{amp}{an amplification factor of differences between \code{fr} and
\code{to}}

\item{grid}{whether to calculate and plot changes across the graphical window
\code{TRUE} or just within the starting shape (\code{FALSE})}

\item{over}{\code{numeric} that indicates how much the thin plate splines
extends over the shapes}

\item{palette}{a color palette such those included in Momocs or produced
with \link{colorRampPalette}}

\item{arr.nb}{\code{numeric} The number of arrows to calculate}

\item{arr.levels}{\code{numeric}. The number of levels for the color of
arrows}

\item{arr.len}{\code{numeric} for the length of arrows}

\item{arr.ang}{\code{numeric} for the angle for arrows' heads}

\item{arr.lwd}{\code{numeric} for the \code{lwd} for drawing arrows}

\item{arr.col}{if \code{palette} is not used the color for arrows}

\item{poly}{whether to draw polygons (for outlines) or points (for landmarks)}

\item{shp}{\code{logical}. whether to draw shapes}

\item{shp.col}{two colors for filling the shapes}

\item{shp.border}{two colors for drawing the borders}

\item{shp.lwd}{two \code{lwd} for drawing shapes}

\item{shp.lty}{two \code{lty} fro drawing the shapes}

\item{legend}{logical whether to plot a legend}

\item{legend.text}{some text for the legend}

\item{...}{additional arguments to feed \link{coo_draw}}
}
\value{
Nothing.
}
\description{
\code{tps_arr}(ows) calculates deformations between two configurations and
illustrate them using arrows.
}
\examples{
data(bot)
botF <- efourier(bot)
x <- mshapes(botF, 'type', nb.pts=80)$shp
fr <- x$beer
to <- x$whisky
tps_arr(fr, to, arr.nb=200, palette=col_sari, amp=3)
tps_arr(fr, to, arr.nb=200, palette=col_sari, amp=3, grid=FALSE)
}
\seealso{
Other thin plate splines: \code{\link{tps2d}},
  \code{\link{tps_grid}}, \code{\link{tps_iso}},
  \code{\link{tps_raw}}
}
