% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_range}
\alias{coo_range}
\alias{coo_range.default}
\alias{coo_range.Coo}
\alias{coo_range_enlarge}
\alias{coo_range_enlarge.default}
\alias{coo_range_enlarge.Coo}
\alias{coo_range_enlarge.list}
\alias{coo_diffrange}
\alias{coo_diffrange.default}
\alias{coo_diffrange.Coo}
\alias{coo_diffrange.list}
\title{Calculate coordinates range}
\usage{
coo_range(coo)

\method{coo_range}{default}(coo)

\method{coo_range}{Coo}(coo)

coo_range_enlarge(coo, k)

\method{coo_range_enlarge}{default}(coo, k = 0)

\method{coo_range_enlarge}{Coo}(coo, k = 0)

\method{coo_range_enlarge}{list}(coo, k = 0)

coo_diffrange(coo)

\method{coo_diffrange}{default}(coo)

\method{coo_diffrange}{Coo}(coo)

\method{coo_diffrange}{list}(coo)
}
\arguments{
\item{coo}{\code{matrix} of \code{(x; y)} coordinates or any \link{Coo} object.}

\item{k}{\code{numeric} proportion by which to enlarge it}
}
\value{
a matrix of range such as \code{(min, max) x (x, y)}
}
\description{
\code{coo_range} simply returns the range,
\code{coo_range_enlarge} enlarges it by a \code{k} proportion.
\code{coo_diffrange} return the amplitude (ie diff after \code{coo_range})
}
\examples{
bot[1] \%>\% coo_range # single shape
bot    \%>\% coo_range # Coo object

bot[1] \%>\% coo_range_enlarge(1/50) # single shape
bot    \%>\% coo_range_enlarge(1/50) # Coo object
}
\seealso{
Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}},
  \code{\link{coo_is_closed}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}},
  \code{\link{coo_likely_clockwise}}, \code{\link{coo_nb}},
  \code{\link{coo_perim}}, \code{\link{coo_rev}},
  \code{\link{coo_right}}, \code{\link{coo_rotatecenter}},
  \code{\link{coo_rotate}}, \code{\link{coo_sample_prop}},
  \code{\link{coo_samplerr}}, \code{\link{coo_sample}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trimbottom}}, \code{\link{coo_trimtop}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_equallyspacedradii}}
}
