% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{coo_ruban}
\alias{coo_ruban}
\title{Plots differences as (colored) segments aka a ruban}
\usage{
coo_ruban(coo, dev, palette = col_heat, normalize = TRUE, ...)
}
\arguments{
\item{coo}{a shape, typically a mean shape}

\item{dev}{numeric a vector of distances or anythinh relevant}

\item{palette}{the color palette to use or any palette}

\item{normalize}{logical whether to normalize (TRUE by default) distances}

\item{...}{other parameters to fed segments, eg lwd (see examples)}
}
\value{
nothing
}
\description{
Useful to display differences between shapes
}
\examples{
ms <- mshapes(efourier(bot , 10), "type")
b <- ms$shp$beer
w <- ms$shp$whisky
# we obtain the mean shape, then euclidean distances between points
m <- mshapes(list(b, w))
d <- edm(b, w)
# First plot
coo_plot(m, plot=FALSE)
coo_draw(b)
coo_draw(w)
coo_ruban(m, d, lwd=5)

#Another example
coo_plot(m, plot=FALSE)
coo_ruban(m, d, palette=col_summer2, lwd=5)

#If you want linewidth rather than color
coo_plot(m, plot=FALSE)
coo_ruban(m, d, palette=col_black)
}
\seealso{
Other plotting functions: \code{\link{coo_arrows}},
  \code{\link{coo_draw}}, \code{\link{coo_listpanel}},
  \code{\link{coo_lolli}}, \code{\link{coo_plot}},
  \code{\link{ldk_chull}}, \code{\link{ldk_confell}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}, \code{\link{plot_devsegments}},
  \code{\link{plot_table}}

Other plotting functions: \code{\link{coo_arrows}},
  \code{\link{coo_draw}}, \code{\link{coo_listpanel}},
  \code{\link{coo_lolli}}, \code{\link{coo_plot}},
  \code{\link{ldk_chull}}, \code{\link{ldk_confell}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}, \code{\link{plot_devsegments}},
  \code{\link{plot_table}}
}
