% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{def_slidings}
\alias{def_slidings}
\title{Defines sliding landmarks matrix}
\usage{
def_slidings(Coo, slidings)
}
\arguments{
\item{Coo}{an \link{Ldk} object}

\item{slidings}{a matrix, a numeric or a list of numeric. See Details}
}
\description{
Defines sliding landmarks matrix
}
\details{
\code{$slidings} in \link{Ldk} must be a 'valid' matrix: containing
ids of coordinates, none of them being lower than 1 and higher the number of coordinates
in \code{$coo}.

\code{slidings} matrix contains 3 columns (\code{before}, \code{slide}, \code{after}).
It is inspired by \code{geomorph} and should be compatible with it.

This matrix can be passed directly if the \code{slidings} argument is a matrix. Of course,
it is strictly equivalent to \code{Ldk$slidings <- slidings}.

\code{slidings} can also be passed as "partition(s)", when sliding landmarks
identified by their ids (which are a row number) are consecutive in the \code{$coo}.

A single partition can be passed either as a numeric (eg \code{4:12}), if points
5 to 11 must be considered as sliding landmarks (4 and 12 being fixed); or as a list of numeric.

See examples below.
}
\examples{
#waiting for a sliding dataset...

}
\seealso{
Other ldk/slidings methods: \code{\link{add_ldk}},
  \code{\link{def_ldk}}, \code{\link{get_ldk}},
  \code{\link{get_slidings}}, \code{\link{rearrange_ldk}},
  \code{\link{slidings_scheme}}
}
