% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{links_delaunay}
\alias{links_delaunay}
\title{Creates links (Delaunay triangulation) between landmarks}
\usage{
links_delaunay(coo)
}
\arguments{
\item{coo}{a matrix (or a list) of (x; y) coordinates}
}
\value{
a matrix that can be passed to \link{ldk_links}, etc. The columns
are the row ids of the original shape.
}
\description{
Creates links (Delaunay triangulation) between landmarks
}
\details{
uses \link{delaunayn} in the \code{geometry} package.
}
\examples{
w <- wings[1]
coo_plot(w, poly=FALSE)
links <- links_delaunay(w)
ldk_links(w, links)
}
\seealso{
Other ldk helpers: \code{\link{def_links}},
  \code{\link{ldk_check}}, \code{\link{links_all}}
}
