% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{ldk_labels}
\alias{ldk_labels}
\title{Add landmarks labels}
\usage{
ldk_labels(ldk, d = 0.05, cex = 2/3, ...)
}
\arguments{
\item{ldk}{a matrix of (x; y) coordinates: where to plot the labels}

\item{d}{how far from the coordinates, on a (centroid-landmark) segment}

\item{cex}{the cex for the label}

\item{...}{additional parameters to fed \link{text}}
}
\description{
Add landmarks labels
}
\examples{
coo_plot(wings[1])
ldk_labels(wings[1])
# closer and smaller
coo_plot(wings[1])
ldk_labels(wings[1], d=0.05, cex=0.5)
}
\seealso{
Other plotting functions: 
\code{\link{coo_arrows}()},
\code{\link{coo_draw}()},
\code{\link{coo_listpanel}()},
\code{\link{coo_lolli}()},
\code{\link{coo_plot}()},
\code{\link{coo_ruban}()},
\code{\link{ldk_chull}()},
\code{\link{ldk_confell}()},
\code{\link{ldk_contour}()},
\code{\link{ldk_links}()},
\code{\link{plot_devsegments}()},
\code{\link{plot_table}()}

Other ldk plotters: 
\code{\link{ldk_chull}()},
\code{\link{ldk_confell}()},
\code{\link{ldk_contour}()},
\code{\link{ldk_links}()}
}
\concept{ldk plotters}
\concept{plotting functions}
