% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupPCA.r
\name{predict.bgPCA}
\alias{predict.bgPCA}
\title{Compute between-group-PC scores from new data}
\usage{
\method{predict}{bgPCA}(object, newdata, ...)
}
\arguments{
\item{object}{object of class \code{bgPCA} returned from \code{\link{groupPCA}}}

\item{newdata}{matrix or 3D array containing data in the same format as originally used to compute groupPCA}

\item{...}{currently not used.}
}
\value{
returns the between-group-PC scores for new data
}
\description{
Compute between-group-PC scores from new data
}
\examples{
data(boneData)

boneLMPart <- boneLM[,,-(1:2)]
procPart <- procSym(boneLMPart)
pop_sex <- name2factor(boneLMPart, which=3:4)
## compute group PCA without first 2 specimens
gpcaPart <- groupPCA(procPart$orpdata, groups=pop_sex, rounds=0, mc.cores=2,cv=FALSE)
## align new data to Procrustes analysis
newdata <- align2procSym(procPart,boneLM[,,1:2])
## get scores for new data
newscores <- predict(gpcaPart,newdata)
}
