% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindArr.r
\name{bindArr}
\alias{bindArr}
\title{concatenate multiple arrays/matrices}
\usage{
bindArr(..., along = 1)
}
\arguments{
\item{\dots}{matrices and/or arrays with appropriate dimensionality to
combine to one array, or a single list containing suitable matrices, or arrays).}

\item{along}{dimension along which to concatenate.}
}
\value{
returns array of combined matrices/arrays
}
\description{
concatenate multiple 3-dimensional arrays and/or 2-dimensional matrices to
one big array
}
\details{
dimnames, if present and if differing between entries, will be concatenated, separated by a "_".
}
\examples{

A <- matrix(rnorm(18),6,3)
B <- matrix(rnorm(18),6,3)
C <- matrix(rnorm(18),6,3)

#combine to 3D-array
newArr <- bindArr(A,B,C,along=3)
#combine along first dimension
newArr2 <- bindArr(newArr,newArr,along=1)



}
\seealso{
\code{\link{cbind}}, \code{\link{rbind}}, \code{\link{array}}
}
