% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{hotellingsTest}
\alias{hotellingsTest}
\title{Test Unbiasedness of Motion}
\usage{
hotellingsTest(tracks, dim = c("x", "y"), step.spacing = 0, plot = FALSE,
  add = FALSE, ellipse.col = "blue", ellipse.border = "black",
  conf.level = 0.95, ...)
}
\arguments{
\item{tracks}{the tracks whose biasedness is to be determined.}

\item{dim}{vector with the names of the track's 
dimensions that are to be considered. By default c("x", "y").}

\item{step.spacing}{How many positions are to be left out between 
the steps that are considered for the test. For persistent motion, subsequent
steps will be correlated, which leads to too low p-values because Hotelling's 
test assumes that the input data is independent. To avoid this, the resulting
p-value should either be corrected for this dependence (e.g. by adjusting 
the degrees of freedom accordingly), or `step.spacing` should be set to a value
high enough to ensure that the considered steps are approximately independent.}

\item{plot}{logical indicating whether the scatter of the step's directions, 
origin of ordinates (green circle) and the mean of the data points (green 
cross) are to be plotted. (In one dimension also the bounds of the 
condfidence interval are given.) Plot works only in one or two dimensions.}

\item{add}{whether to add the plot to the current plot (\code{TRUE}) or create a}

\item{ellipse.col}{color with which to draw the confidence ellipse of the mean (for
1D, this corresponds to the confidence interval of the mean). 
Use \code{NA} to omit the confidence ellipse.}

\item{ellipse.border}{color of the confidence ellipse border. Use \code{NA} to omit
the border.}

\item{conf.level}{the desired confidence level for the confidence ellipse.}

\item{...}{further arguments passed on to \code{plot}.}
}
\value{
A list with class \code{htest}.
}
\description{
Test the null hypothesis that a given set of tracks originates from an uncorrelated
and unbiased type of motion (e.g., a random walk without drift). This is done by
testing whether the mean step vector is equal to the null vector.
}
\details{
Computes the displacement vectors of all segments in the tracks 
given in \code{tracks}, and performs Hotelling's T-square Test on that vector.
}
\examples{
## Test H_0: T-cells migrate by uncorrelated random walk on x and y coordinates,
## and report the p-value.
hotellingsTest( TCells )$p.value

}
\references{
Johannes Textor, Antonio Peixoto, Sarah E. Henrickson, Mathieu
 Sinn, Ulrich H. von Andrian and Juergen Westermann (2011),
Defining the Quantitative Limits of Intravital Two-Photon Lymphocyte Tracking.
\emph{PNAS} \bold{108}(30):12401--12406. doi:10.1073/pnas.1102288108
}

