\name{getSavedata_Bparams}
\Rdversion{1.1}
\alias{getSavedata_Bparams}
\title{Load the draws from the Bayesian model posterior distribution (SAVEDATA BPARAMETERS) command into an R data.frame}
\description{
This function reads a the BPARAMETERS output file from the Mplus SAVEDATA BPARAMETERS command
and returns an R \code{data.frame} object.
}
\usage{
getSavedata_Bparams(outfile, discardBurnin=TRUE)
}
\arguments{
  \item{outfile}{required. The name of the Mplus output file to read. Can be an absolute or relative path.
  If \code{outfile} is a relative path or just the filename, then it is assumed that the file resides in
  the working directory \code{getwd()}.}
  \item{discardBurnin}{optional. Whether to discard the burn-in phase of each MCMC chain (i.e., the first half).}
}
\value{
a \code{list} containing the draws from the MCMC chains for a Bayesian model that uses the 
SAVEDATA BPARAMETERS command. Each list element corresponds to a single MCMC chain, as specified by
the ANALYSIS: CHAINS syntax in \code{Mplus}. If discardBurnin is \code{FALSE}, then a superordinate list is
provided that divides output in terms of burn-in versus valid draw halves of the MCMC chains. For documentation
of how \code{Mplus} implements chain convergence checks and MCMC draws, see here: \url{http://www.statmodel.com/download/Bayes3.pdf}.
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{Michael Hallquist, Florian Boeing-Messing}
\note{
Note that the \code{outfile} parameter should refer to the Mplus output file (.out extension), not the
actual dataset generated by SAVEDATA. This function reads information about the dataset from the .out file
and loads the dataset accordingly.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{getSavedata_Fileinfo}}, \code{\link{getSavedata_Data}}
}
%\examples{
%fileInfo <- getSavedata_Data("C:/Program Files/Mplus/Test Output.out")
%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{interface}
