% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiSummary.R
\name{MultiSummary}
\alias{MultiSummary}
\alias{MultiSummary,}
\alias{multi.summary}
\title{Multivariate genome-wide association scan using summary statistics}
\usage{
MultiSummary(x, index = NULL, type = "direct", vars = NULL)
}
\arguments{
\item{x}{A data object of class \code{multi.summary} loaded by the function \code{load.summary}.}

\item{index}{A numeric vector that gives the indices of the traits to be analyzed jointly.}

\item{type}{A string gives the type of analysis. Default is \code{"outbred"}, referring to 
general outbred populations, following Hardy-Weinberg equilibrium. \code{"inbred"} refers to 
inbred populations, where no heterzygotes exists, namely, allele frequency = genotype frequency.
\code{"precise"} refers to precise test statistics, especially when the individual-level data 
are available, for which the argument \code{vars} has to be given. \code{"direct"} refers to 
test statistics directly constructed from the T-statistics in univariate GWAS, this provides a
scale-invariant test most similar to the direct MANOVA, but may be less powerful in some scenarios.}

\item{vars}{A numeric vector gives the variance of the genotypes at each SNP, e.g. coded as 0, 1 and 2.
Only used when \code{type = "precise"}.}
}
\value{
The function returns a data frame containing the multi-trait GWAS results, where the row names are
the variants names. The column names are: variant name (\code{Marker}), allele frequency (\code{Freq}),
the smallest sample size of the traits (\code{N}), effect on the phenotype score (\code{Beta.S}, see reference),
standard error (\code{SE}), p-value (\code{P}), and the rest the coefficients to construct the phenotype score
(see reference).
}
\description{
This function performs multivariate GWA analysis using meta-GWAS summary statistics
}
\examples{
\dontrun{
## download the six example files from:
## https://www.dropbox.com/sh/hhta45cewvvea2s/AADfj4OXlbroToZAwIii2Buha?dl=0
## the summary statistics from Randall et al. (2013) PLoS Genet
## for males only
## bmi: body mass index
## hip: hip circumference
## wc: waist circumference
## whr: waist-hip ratio

## load the prepared set of independent SNPs
indep.snps <- as.character(read.table('indep.snps')$V1)

## load summary statistics of the six traits
stats.male <- load.summary(files = c('bmi.txt', 'height.txt', 
                           'weight.txt', 'hip.txt', 'wc.txt', 
                           'whr.txt'), indep.snps = indep.snps)

## perform multi-trait meta-GWAS
result <- MultiSummary(stats.male)
head(result)
}
}
\references{
Xia Shen, Zheng Ning, Yakov Tsepilov, Peter K. Joshi,
James F. Wilson, Yudi Pawitan, Chris S. Haley, Yurii S. Aulchenko (2016).
Fast pleiotropic meta-analysis for genetic studies. \emph{Submitted}.
}
\seealso{
\code{load.summary}
}
\author{
Xia Shen
}
\keyword{meta-analysis}
\keyword{multivariate,}
