% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def.quantreg.r
\name{def.quantreg}
\alias{def.quantreg}
\title{Define a Linear Quantile Regression Model}
\usage{
def.quantreg(formula, tau = 0.5, subset, weights = NULL, ...)
}
\arguments{
\item{formula}{The formula of the linear quantile regression model to be fitted.}

\item{tau}{The quantile to be estimated, which is generally a number between 0 and 1.}

\item{subset}{The subset of observations to be used.}

\item{weights}{The prior weights to be used in the model.}

\item{...}{Addition arguments for the function \code{\link[quantreg]{rq}}.}
}
\description{
Define a quantile regression model. All the arguments in \code{\link[quantreg]{rq}} of the \code{quantreg} package are allowed except \code{data}.
}
\examples{
# A quantile regression model with response Y and covariates X1 and X2 at the 75th percentile
reg <- def.quantreg(formula = Y ~ X1 + X2, tau = 0.75)
}
\seealso{
\code{\link[quantreg]{rq}}.
}
