% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_Poly_NH_Multi_Inv}
\alias{Hermite_Poly_NH_Multi_Inv}
\title{Inverse of d-variate T-Hermite Polynomial}
\usage{
Hermite_Poly_NH_Multi_Inv(H_N_X, N, Sig2 = diag(length(H_N_X[[1]])))
}
\arguments{
\item{H_N_X}{The list  of  d-variate T-Hermite Polynomials of order  from 1
to N evaluated at X}

\item{N}{the highest polynomial order}

\item{Sig2}{The variance matrix of x, the default is set to unit matrix}
}
\value{
The list of \eqn{x}, \eqn{x^{\otimes 2}},... \eqn{x^{\otimes N}}
}
\description{
Compute the powers of vector variate x when Hermite polynomials are given
}
\examples{
x<-c(1,3)
Sig2 <- diag(length(x)) # matrix(c(1,0,0,1),2,2,byrow=T)
N<-4
H_N_X<-Hermite_Poly_HN_Multi(x,N,Sig2)
x_ad_n <- Hermite_Poly_NH_Multi_Inv(H_N_X,N,Sig2)
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 4.6.2, (4.72), p.223
}
\seealso{
Other Hermite: 
\code{\link{Hermite_CoeffMulti}()},
\code{\link{Hermite_Coeff}()},
\code{\link{Hermite_N_Cov_X1_X2}()},
\code{\link{Hermite_Nth}()},
\code{\link{Hermite_Poly_HN_Multi}()},
\code{\link{Hermite_Poly_HN}()},
\code{\link{Hermite_Poly_NH_Inv}()}
}
\concept{Hermite}
