% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_split_improvement.R
\name{MeanSplitImprovement}
\alias{MeanSplitImprovement}
\title{Mean Split Improvement Importance Function}
\usage{
MeanSplitImprovement(
  X,
  Y,
  sample_size = trunc(nrow(X) * 0.8),
  num_trees = 100,
  m_feature = ncol(X),
  min_leaf = 10,
  alpha_threshold = 0
)
}
\arguments{
\item{X}{Feature matrix}

\item{Y}{Target matrix}

\item{sample_size}{Size of random subset for each tree generation}

\item{num_trees}{Number of Trees to generate}

\item{m_feature}{Number of randomly selected features considered for a split in each regression tree node, which
must be positive integer and less than N (number of input features)}

\item{min_leaf}{Minimum number of samples in the leaf node. If a node has less than or equal
to min_leaf samples, then there will be no splitting in that node and this node
will be considered as a leaf node. Valid input is positive integer, which is less
than or equal to M (number of training samples)}

\item{alpha_threshold}{threshold for split significant testing. If default value of 0 is specified,
all the node splits will contribute to result, otherwise only those splits with improvement greater
than 1-alpha critical value of an f-statistic do.}
}
\value{
Vector of size N x 1
}
\description{
Mean Split Improvement Importance Function
}
\examples{
X = matrix(runif(50*5), 50, 5)
Y = matrix(runif(50*2), 50, 2)
MeanSplitImprovement(X, Y)
}
